/*
 * Decompiled with CFR 0.152.
 */
package net.teamfruit.emojicord;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.teamfruit.emojicord.Log;
import net.teamfruit.emojicord.emoji.Models;
import net.teamfruit.emojicord.util.DataUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ConnectionClosedException;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpEntityContainer;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.impl.io.DefaultBHttpServerConnection;
import org.apache.hc.core5.http.impl.io.DefaultBHttpServerConnectionFactory;
import org.apache.hc.core5.http.impl.io.HttpService;
import org.apache.hc.core5.http.impl.routing.RequestRouter;
import org.apache.hc.core5.http.io.HttpRequestHandler;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.io.support.BasicHttpServerRequestHandler;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.protocol.BasicHttpContext;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.http.protocol.HttpProcessorBuilder;
import org.apache.hc.core5.http.protocol.ResponseConnControl;
import org.apache.hc.core5.http.protocol.ResponseContent;
import org.apache.hc.core5.http.protocol.ResponseDate;
import org.apache.hc.core5.http.protocol.ResponseServer;

public class CallbackServerInstance
implements AutoCloseable {
    private Consumer<Models.EmojiDiscordList> consumer;
    private Predicate<String> keyChecker;
    private final ExecutorService listenerExecutor;
    private final ExecutorService workerExecutor;
    private ServerSocket serversocket;

    public CallbackServerInstance(Consumer<Models.EmojiDiscordList> consumer, Predicate<String> keyChecker) throws IOException {
        this(consumer, keyChecker, 0);
    }

    public CallbackServerInstance(Consumer<Models.EmojiDiscordList> consumer, Predicate<String> keyChecker, int port) throws IOException {
        this.consumer = consumer;
        this.keyChecker = keyChecker;
        this.listenerExecutor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("emojicord-web-listener-%d").build());
        this.workerExecutor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("emojicord-web-worker-%d").build());
        HttpProcessor httpproc = HttpProcessorBuilder.create().add(new ResponseDate()).add(new ResponseServer("GoslingCord/1.1")).add(new ResponseContent()).add(new ResponseConnControl()).build();
        RequestRouter<HttpRequestHandler> registry = RequestRouter.builder().addRoute("*", "*", new HttpCallbackHandler()).build();
        BasicHttpServerRequestHandler serverHandler = new BasicHttpServerRequestHandler(registry);
        HttpService httpService = new HttpService(httpproc, serverHandler);
        DefaultBHttpServerConnectionFactory connFactory = DefaultBHttpServerConnectionFactory.builder().build();
        this.serversocket = new ServerSocket(port, 0, InetAddress.getByName(null));
        this.listenerExecutor.submit(() -> {
            Log.log.info("Emojicord Web Listener on port " + this.serversocket.getLocalPort());
            try {
                while (!Thread.interrupted()) {
                    try {
                        Socket socket = this.serversocket.accept();
                        DefaultBHttpServerConnection conn = connFactory.createConnection(socket);
                        Log.log.info("Incoming connection from " + socket.getInetAddress());
                        this.workerExecutor.submit(() -> {
                            BasicHttpContext context = new BasicHttpContext(null);
                            try {
                                while (!Thread.interrupted() && conn.isOpen()) {
                                    httpService.handleRequest(conn, context);
                                }
                            }
                            catch (ConnectionClosedException ex) {
                                Log.log.info("Client closed connection");
                            }
                            catch (IOException ex) {
                                Log.log.error("IO error: " + ex.getMessage());
                            }
                            catch (HttpException ex) {
                                Log.log.error("Unrecoverable HTTP protocol violation: " + ex.getMessage());
                            }
                            finally {
                                try {
                                    conn.close();
                                }
                                catch (IOException ex) {}
                            }
                        });
                    }
                    catch (InterruptedIOException ex) {
                        break;
                    }
                    catch (IOException e) {
                        Log.log.error("IO error initialising connection thread: ", (Throwable)e);
                        break;
                    }
                }
            }
            finally {
                IOUtils.closeQuietly((ServerSocket)this.serversocket);
            }
            Log.log.info("Emojicord Web Listener closed");
        });
    }

    public int getPort() {
        return this.serversocket.getLocalPort();
    }

    @Override
    public void close() {
        this.listenerExecutor.shutdownNow();
        this.workerExecutor.shutdownNow();
        IOUtils.closeQuietly((ServerSocket)this.serversocket);
    }

    public static void main(String[] args) throws IOException {
        new CallbackServerInstance(e -> {}, e -> true);
    }

    private class HttpCallbackHandler
    implements HttpRequestHandler {
        private HttpCallbackHandler() {
        }

        @Override
        public void handle(ClassicHttpRequest request, ClassicHttpResponse response, HttpContext context) throws HttpException, IOException {
            String[] split;
            response.addHeader(new BasicHeader("Access-Control-Allow-Origin", "https://emojicord.teamfruit.net"));
            response.addHeader(new BasicHeader("Access-Control-Allow-Methods", "POST, OPTIONS"));
            response.addHeader(new BasicHeader("Access-Control-Allow-Headers", "Authorization, Content-Type"));
            response.addHeader(new BasicHeader("Access-Control-Max-Age", "86400"));
            response.addHeader(new BasicHeader("Accept", "application/json"));
            response.addHeader(new BasicHeader("Accept-Charset", "utf-8"));
            String method = request.getMethod().toUpperCase(Locale.ENGLISH);
            if (method.equals("OPTIONS")) {
                response.setCode(204);
                Log.log.debug("OPTIONS");
                return;
            }
            String target = request.getRequestUri();
            Log.log.info(String.format("URL: %s, Method: %s", target, method));
            if (!target.equals("/")) {
                response.setCode(404);
                response.setEntity(new StringEntity("NG\nNot Found", ContentType.create("text/plain", StandardCharsets.UTF_8)));
                Log.log.warn("Invalid Request: Not Found");
                return;
            }
            if (method.equals("GET")) {
                response.setCode(200);
                response.setEntity(new StringEntity("OK", ContentType.create("text/plain", StandardCharsets.UTF_8)));
                Log.log.debug("GET");
                return;
            }
            boolean authorized = false;
            Header authorization = request.getFirstHeader("Authorization");
            if (authorization != null && (split = StringUtils.split((String)authorization.getValue(), (String)" ")) != null && split.length == 2 && StringUtils.equals((CharSequence)split[0], (CharSequence)"token")) {
                Log.log.debug(String.format("Key Check: %s", split[1]));
                authorized = CallbackServerInstance.this.keyChecker.test(split[1]);
            }
            if (!authorized) {
                response.setCode(401);
                response.setEntity(new StringEntity("NG\nInvalid Key", ContentType.create("text/plain", StandardCharsets.UTF_8)));
                Log.log.warn("Invalid Request: Invalid Key");
                return;
            }
            if (!method.equals("POST")) {
                response.setCode(405);
                response.setEntity(new StringEntity("NG\nMethod Not Allowed", ContentType.create("text/plain", StandardCharsets.UTF_8)));
                Log.log.warn("Invalid Request: Method Not Allowed");
                return;
            }
            if (!(request instanceof HttpEntityContainer)) {
                response.setCode(400);
                response.setEntity(new StringEntity("NG\nNo Request Data", ContentType.create("text/plain", StandardCharsets.UTF_8)));
                Log.log.warn("Invalid Request: No Request Data");
                return;
            }
            ClassicHttpRequest eRequest = request;
            HttpEntity entity = eRequest.getEntity();
            byte[] data = EntityUtils.toByteArray(entity);
            Log.log.debug(StringUtils.toEncodedString((byte[])data, (Charset)StandardCharsets.UTF_8));
            Models.EmojiDiscordList callback = DataUtils.loadStream(new ByteArrayInputStream(data), Models.EmojiDiscordList.class, "Parsing Web Callback");
            if (callback == null || StringUtils.isEmpty((CharSequence)callback.id) || StringUtils.isEmpty((CharSequence)callback.name)) {
                response.setCode(400);
                response.setEntity(new StringEntity("NG\nInvalid Json", ContentType.create("text/plain", StandardCharsets.UTF_8)));
                Log.log.warn("Invalid Request: Invalid Json");
                return;
            }
            response.setCode(200);
            response.setEntity(new StringEntity("OK", ContentType.create("text/plain", StandardCharsets.UTF_8)));
            CallbackServerInstance.this.consumer.accept(callback);
        }
    }
}

