/*
 * Decompiled with CFR 0.152.
 */
package net.teamfruit.emojicord.gui;

import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiTextField;
import net.minecraftforge.common.ForgeVersion;
import net.teamfruit.emojicord.ClientProxy;
import net.teamfruit.emojicord.EmojicordConfig;
import net.teamfruit.emojicord.EmojicordWeb;
import net.teamfruit.emojicord.OSUtils;
import net.teamfruit.emojicord.compat.Compat;
import net.teamfruit.emojicord.compat.OpenGL;
import net.teamfruit.emojicord.emoji.DiscordEmojiIdDictionary;
import net.teamfruit.emojicord.emoji.Models;
import net.teamfruit.emojicord.gui.IChatOverlay;
import net.teamfruit.emojicord.gui.Rectangle2d;
import net.teamfruit.emojicord.util.MathHelper;

public class EmojiSettings
implements IChatOverlay {
    public static Runnable showSettings;
    public static Runnable onWindowActive;
    public final GuiChat chatScreen;
    public final GuiTextField inputField;
    public final FontRenderer font;
    public int mouseX;
    public int mouseY;
    private EmojiSettingMenu settingMenu;
    private final Rectangle2d rectScreen;
    private EmojiAdding addGui;

    public EmojiSettings(GuiChat chatScreen) {
        this.chatScreen = chatScreen;
        this.font = Compat.getMinecraft().field_71466_p;
        this.inputField = chatScreen.field_146415_a;
        this.rectScreen = new Rectangle2d(0, 0, this.chatScreen.field_146294_l, this.chatScreen.field_146295_m);
        showSettings = this::show;
    }

    private void drawString(Compat.CompatMatrixStack compatMatrixStack, String text, float x, float y, int color) {
        this.font.func_175063_a(text, x, y, color);
    }

    @Override
    public boolean onDraw(Compat.CompatMatrixStack compatMatrixStack) {
        if (this.settingMenu != null) {
            this.settingMenu.onDraw(compatMatrixStack);
        }
        return false;
    }

    @Override
    public boolean onMouseClicked(int button) {
        return this.settingMenu != null && this.settingMenu.onMouseClicked(button);
    }

    @Override
    public boolean onMouseScroll(double scrollDelta) {
        return this.settingMenu != null && this.settingMenu.onMouseScroll(scrollDelta);
    }

    @Override
    public boolean onMouseInput(int mouseX, int mouseY) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        return false;
    }

    @Override
    public boolean onCharTyped(char typed, int keycode) {
        return this.settingMenu != null && this.settingMenu.onCharTyped(typed, keycode);
    }

    @Override
    public boolean onKeyPressed(int keycode) {
        return this.settingMenu != null && this.settingMenu.onKeyPressed(keycode);
    }

    @Override
    public void onTick() {
        if (this.settingMenu != null) {
            this.settingMenu.onTick();
        }
    }

    public void show() {
        int width = 200;
        int height = 180;
        this.settingMenu = new EmojiSettingMenu(this.chatScreen.field_146294_l / 2, this.chatScreen.field_146295_m / 2, 200, 180);
    }

    public void hide() {
        this.settingMenu = null;
    }

    private class EmojiSettingMenu {
        private final Rectangle2d rectangle;
        private final Rectangle2d rectTop;
        private final Rectangle2d rectLogo;
        private final Rectangle2d rectTopRight;
        private final Rectangle2d rectName;
        private final Rectangle2d rectBottom;
        private final Rectangle2d rectButton1;
        private final Rectangle2d rectButton2;
        private final Rectangle2d rectButton3;
        private final Rectangle2d rectMain;
        private final Rectangle2d rectUpdate;
        private boolean focused = true;
        private final ForgeVersion.CheckResult update;

        public EmojiSettingMenu(int posX, int posY, int width, int height) {
            this.rectangle = new Rectangle2d(posX - width / 2, posY - height / 2, width, height);
            this.rectTop = new Rectangle2d(this.rectangle.getX(), this.rectangle.getY(), this.rectangle.getWidth(), 57);
            this.rectLogo = new Rectangle2d(this.rectTop.getX(), this.rectTop.getY(), 50, this.rectTop.getHeight()).inner(0, 4, 0, 0);
            this.rectTopRight = this.rectTop.inner(this.rectLogo.getX() + this.rectLogo.getWidth() - this.rectTop.getX(), 0, 0, 0);
            this.rectName = this.rectTopRight.inner(10, 20, 0, 0);
            this.rectBottom = new Rectangle2d(this.rectangle.getX(), this.rectangle.getY() + this.rectangle.getHeight() - 52, this.rectangle.getWidth(), 52);
            Rectangle2d rectButton1Rect = new Rectangle2d(this.rectBottom.getX(), this.rectBottom.getY(), this.rectBottom.getWidth(), 20);
            Rectangle2d rectButton2Rect = new Rectangle2d(this.rectBottom.getX(), rectButton1Rect.getY() + rectButton1Rect.getHeight(), this.rectBottom.getWidth(), 15);
            Rectangle2d rectButton3Rect = new Rectangle2d(this.rectBottom.getX(), rectButton2Rect.getY() + rectButton2Rect.getHeight(), this.rectBottom.getWidth(), 15);
            this.rectButton1 = rectButton1Rect.inner(3, 2, 3, 1);
            this.rectButton2 = rectButton2Rect.inner(3, 1, 3, 1);
            this.rectButton3 = rectButton3Rect.inner(3, 1, 3, 1);
            this.rectMain = new Rectangle2d(this.rectangle.getX(), this.rectTop.getY() + this.rectTop.getHeight(), this.rectangle.getWidth(), this.rectBottom.getY() - (this.rectTop.getY() + this.rectTop.getHeight()));
            this.rectUpdate = new Rectangle2d(this.rectName.getX(), this.rectName.getY(), this.rectName.getWidth() - 5, this.rectName.getHeight() - 5);
            this.update = EmojicordConfig.UPDATE.showUpdate.get() != false ? Compat.CompatVersionChecker.getResult("emojicord") : null;
        }

        public boolean onDraw(Compat.CompatMatrixStack compatMatrixStack) {
            IChatOverlay.fill(EmojiSettings.this.rectScreen, 0x77000000);
            IChatOverlay.fill(this.rectangle, -13223617);
            IChatOverlay.fill(this.rectTop, -14671323);
            OpenGL.glPushMatrix();
            OpenGL.glTranslatef(this.rectLogo.getX() + 3, this.rectLogo.getY() + 3, 0.0f);
            OpenGL.glScalef(5.0f, 5.0f, 1.0f);
            EmojiSettings.this.drawString(compatMatrixStack, "<:logo:1343350433317388378>", 0.0f, 0.0f, -1);
            OpenGL.glPopMatrix();
            if (this.update != null && this.update.status == ForgeVersion.Status.OUTDATED) {
                String name = "GoslingCord";
                EmojiSettings.this.drawString(compatMatrixStack, "GoslingCord", this.rectName.getX(), this.rectName.getY() - 15, -1);
                EmojiSettings.this.drawString(compatMatrixStack, "by RGosling/TeamFruit", this.rectName.getX() + 5 + EmojiSettings.this.font.func_78256_a("GoslingCord"), this.rectName.getY() - 15, -8947849);
                boolean b = this.rectUpdate.contains(EmojiSettings.this.mouseX, EmojiSettings.this.mouseY);
                double t = (Math.sin((double)System.currentTimeMillis() / 200.0) + 1.0) / 2.0;
                IChatOverlay.fill(this.rectUpdate, 0xFAA61A | (b ? 255 : (int)MathHelper.lerp(119.0f, 255.0f, (float)t)) << 24);
                String text1 = Compat.CompatI18n.format("emojicord.gui.settings.update", this.update.target);
                EmojiSettings.this.drawString(compatMatrixStack, text1, this.rectUpdate.getX() + this.rectUpdate.getWidth() / 2 - EmojiSettings.this.font.func_78256_a(text1) / 2, this.rectUpdate.getY() + 7, -1);
                String text2 = Compat.CompatI18n.format("emojicord.gui.settings.update.click", this.update.target);
                EmojiSettings.this.drawString(compatMatrixStack, text2, this.rectUpdate.getX() + this.rectUpdate.getWidth() / 2 - EmojiSettings.this.font.func_78256_a(text2) / 2, this.rectUpdate.getY() + 18, -1);
            } else {
                OpenGL.glPushMatrix();
                OpenGL.glTranslatef(this.rectName.getX(), this.rectName.getY(), 0.0f);
                OpenGL.glScalef(1.5f, 1.5f, 1.0f);
                EmojiSettings.this.drawString(compatMatrixStack, "GoslingCord", 0.0f, 0.0f, -1);
                OpenGL.glPopMatrix();
                EmojiSettings.this.drawString(compatMatrixStack, "by RGosling/TeamFruit", this.rectName.getX() + 10, this.rectName.getY() + 15, -8947849);
            }
            if (EmojiSettings.this.addGui == null) {
                Rectangle2d rectInner = this.rectMain.inner(2, 2, 2, 2);
                int posY = rectInner.getY() + 2;
                EmojiSettings.this.drawString(compatMatrixStack, Compat.CompatI18n.format("emojicord.gui.settings.menu.packs", new Object[0]), rectInner.getX() + 2, posY, -8947849);
                posY += 13;
                for (Models.EmojiDiscordList group : DiscordEmojiIdDictionary.instance.groups) {
                    if (posY + 20 > rectInner.getY() + rectInner.getHeight()) {
                        EmojiSettings.this.drawString(compatMatrixStack, Compat.CompatI18n.format("emojicord.gui.settings.menu.more", new Object[0]), rectInner.getX() + 12, posY, -8947849);
                        break;
                    }
                    EmojiSettings.this.drawString(compatMatrixStack, group.name, rectInner.getX() + 12, posY, -1);
                    posY += 13;
                }
                IChatOverlay.fill(this.rectButton1, this.rectButton1.contains(EmojiSettings.this.mouseX, EmojiSettings.this.mouseY) ? -12803212 : -12339839);
                String text = Compat.CompatI18n.format("emojicord.gui.settings.menu.button.web", new Object[0]);
                EmojiSettings.this.drawString(compatMatrixStack, text, this.rectButton1.getX() + this.rectButton1.getWidth() / 2 - EmojiSettings.this.font.func_78256_a(text) / 2, this.rectButton1.getY() + 5, -1);
                IChatOverlay.fill(this.rectButton2, this.rectButton2.contains(EmojiSettings.this.mouseX, EmojiSettings.this.mouseY) ? -9995324 : -9270822);
                text = Compat.CompatI18n.format("emojicord.gui.settings.menu.button.manual", new Object[0]);
                EmojiSettings.this.drawString(compatMatrixStack, text, this.rectButton2.getX() + this.rectButton2.getWidth() / 2 - EmojiSettings.this.font.func_78256_a(text) / 2, this.rectButton2.getY() + 2, -1);
                IChatOverlay.fill(this.rectButton3, this.rectButton3.contains(EmojiSettings.this.mouseX, EmojiSettings.this.mouseY) ? -10328467 : -9275779);
                text = Compat.CompatI18n.format("emojicord.gui.settings.menu.button.done", new Object[0]);
                EmojiSettings.this.drawString(compatMatrixStack, text, this.rectButton3.getX() + this.rectButton3.getWidth() / 2 - EmojiSettings.this.font.func_78256_a(text) / 2, this.rectButton3.getY() + 2, -1);
            } else if (!EmojiSettings.this.addGui.isClosing()) {
                if (!EmojiSettings.this.addGui.isApplyPreferred()) {
                    OpenGL.glPushMatrix();
                    OpenGL.glTranslatef(this.rectMain.getX() + this.rectMain.getWidth() / 2 - 25, this.rectMain.getY(), 0.0f);
                    OpenGL.glScalef(5.0f, 5.0f, 1.0f);
                    EmojiSettings.this.drawString(compatMatrixStack, "<:info:633136157626204181>", 0.0f, 0.0f, -1);
                    OpenGL.glPopMatrix();
                    Rectangle2d rectInner = this.rectMain.inner(2, 52, 2, 2);
                    int posY = 0;
                    for (String desc : EmojiSettings.this.font.func_78280_d(EmojiSettings.this.addGui.getDescription(), rectInner.getWidth() - 2).split("\n")) {
                        EmojiSettings.this.drawString(compatMatrixStack, desc, rectInner.getX() + 2, rectInner.getY() + 2 + posY, -8947849);
                        posY += 12;
                    }
                    IChatOverlay.fill(this.rectButton3, this.rectButton3.contains(EmojiSettings.this.mouseX, EmojiSettings.this.mouseY) ? -2604992 : -1030329);
                    String text = Compat.CompatI18n.format("emojicord.gui.settings.waiting.button.cancel", new Object[0]);
                    EmojiSettings.this.drawString(compatMatrixStack, text, this.rectButton3.getX() + this.rectButton3.getWidth() / 2 - EmojiSettings.this.font.func_78256_a(text) / 2, this.rectButton3.getY() + 2, -1);
                } else {
                    OpenGL.glPushMatrix();
                    OpenGL.glTranslatef(this.rectMain.getX() + this.rectMain.getWidth() / 2 - 25, this.rectMain.getY(), 0.0f);
                    OpenGL.glScalef(5.0f, 5.0f, 1.0f);
                    EmojiSettings.this.drawString(compatMatrixStack, "<:check:633136145122983957>", 0.0f, 0.0f, -1);
                    OpenGL.glPopMatrix();
                    Rectangle2d rectInner = this.rectMain.inner(2, 52, 2, 2);
                    int posY = 0;
                    for (String desc : EmojiSettings.this.font.func_78280_d(EmojiSettings.this.addGui.getApplyPreferredDescription(), rectInner.getWidth() - 2).split("\n")) {
                        EmojiSettings.this.drawString(compatMatrixStack, desc, rectInner.getX() + 2, rectInner.getY() + 2 + posY, -8947849);
                        posY += 12;
                    }
                    IChatOverlay.fill(this.rectButton3, this.rectButton3.contains(EmojiSettings.this.mouseX, EmojiSettings.this.mouseY) ? -12803212 : -12339839);
                    String text = Compat.CompatI18n.format("emojicord.gui.settings.completed.button.done", new Object[0]);
                    EmojiSettings.this.drawString(compatMatrixStack, text, this.rectButton3.getX() + this.rectButton3.getWidth() / 2 - EmojiSettings.this.font.func_78256_a(text) / 2, this.rectButton3.getY() + 2, -1);
                }
            } else {
                OpenGL.glPushMatrix();
                OpenGL.glTranslatef(this.rectMain.getX() + this.rectMain.getWidth() / 2 - 25, this.rectMain.getY(), 0.0f);
                OpenGL.glScalef(5.0f, 5.0f, 1.0f);
                EmojiSettings.this.drawString(compatMatrixStack, "<:warning:633136170250928151>", 0.0f, 0.0f, -1);
                OpenGL.glPopMatrix();
                Rectangle2d rectInner = this.rectMain.inner(2, 52, 2, 2);
                int posY = 0;
                for (String desc : EmojiSettings.this.font.func_78280_d(EmojiSettings.this.addGui.getClosingDescription(), rectInner.getWidth() - 2).split("\n")) {
                    EmojiSettings.this.drawString(compatMatrixStack, desc, rectInner.getX() + 2, rectInner.getY() + 2 + posY, -8947849);
                    posY += 12;
                }
                IChatOverlay.fill(this.rectButton2, this.rectButton2.contains(EmojiSettings.this.mouseX, EmojiSettings.this.mouseY) ? -2604992 : -1030329);
                String text = Compat.CompatI18n.format("emojicord.gui.settings.aborting.button.ok", new Object[0]);
                EmojiSettings.this.drawString(compatMatrixStack, text, this.rectButton2.getX() + this.rectButton2.getWidth() / 2 - EmojiSettings.this.font.func_78256_a(text) / 2, this.rectButton2.getY() + 2, -1);
                IChatOverlay.fill(this.rectButton3, this.rectButton3.contains(EmojiSettings.this.mouseX, EmojiSettings.this.mouseY) ? -10328467 : -9275779);
                text = Compat.CompatI18n.format("emojicord.gui.settings.aborting.button.cancel", new Object[0]);
                EmojiSettings.this.drawString(compatMatrixStack, text, this.rectButton3.getX() + this.rectButton3.getWidth() / 2 - EmojiSettings.this.font.func_78256_a(text) / 2, this.rectButton3.getY() + 2, -1);
            }
            return false;
        }

        public boolean onMouseClicked(int button) {
            if (EmojiSettings.this.addGui != null) {
                if (!EmojiSettings.this.addGui.isClosing()) {
                    if (this.rectButton3.contains(EmojiSettings.this.mouseX, EmojiSettings.this.mouseY)) {
                        EmojiSettings.this.addGui.onApplying();
                        return true;
                    }
                } else {
                    if (this.rectButton2.contains(EmojiSettings.this.mouseX, EmojiSettings.this.mouseY)) {
                        EmojiSettings.this.addGui.onOK();
                        return true;
                    }
                    if (this.rectButton3.contains(EmojiSettings.this.mouseX, EmojiSettings.this.mouseY)) {
                        EmojiSettings.this.addGui.onCancel();
                        return true;
                    }
                }
            } else {
                if (this.update != null && this.update.status == ForgeVersion.Status.OUTDATED && this.rectUpdate.contains(EmojiSettings.this.mouseX, EmojiSettings.this.mouseY)) {
                    if (this.update.url != null) {
                        OSUtils.getOSType().openURI(this.update.url);
                    }
                    return true;
                }
                if (this.rectButton3.contains(EmojiSettings.this.mouseX, EmojiSettings.this.mouseY) || !this.rectangle.contains(EmojiSettings.this.mouseX, EmojiSettings.this.mouseY)) {
                    EmojiSettings.this.hide();
                    return true;
                }
                if (this.rectButton1.contains(EmojiSettings.this.mouseX, EmojiSettings.this.mouseY)) {
                    EmojiSettings.this.addGui = new WebAdding();
                    return true;
                }
                if (this.rectButton2.contains(EmojiSettings.this.mouseX, EmojiSettings.this.mouseY)) {
                    EmojiSettings.this.addGui = new ManualAdding();
                    return true;
                }
            }
            return true;
        }

        public boolean onMouseScroll(double scrollDelta) {
            return false;
        }

        public boolean onCharTyped(char typed, int keycode) {
            return EmojiSettings.this.addGui != null;
        }

        public boolean onKeyPressed(int keycode) {
            return EmojiSettings.this.addGui != null;
        }

        public void onTick() {
            if (EmojiSettings.this.addGui != null) {
                boolean lastFocused = this.focused;
                this.focused = Compat.getMinecraft().field_71415_G;
                if (this.focused != lastFocused) {
                    EmojiSettings.this.addGui.onWindowFocus();
                }
            }
        }

        private class ManualAdding
        implements EmojiAdding {
            private boolean closing;
            private boolean changed;

            public ManualAdding() {
                ClientProxy.eventHandler.hasDictionaryDirectoryChanged();
                OSUtils.getOSType().openFile(DiscordEmojiIdDictionary.instance.getDictionaryDirectory());
            }

            @Override
            public boolean isClosing() {
                return this.closing;
            }

            @Override
            public boolean isApplyPreferred() {
                if (!this.changed) {
                    this.changed = ClientProxy.eventHandler.hasDictionaryDirectoryChanged();
                }
                return this.changed;
            }

            @Override
            public void onApplying() {
                this.closing = true;
                if (this.changed) {
                    this.onOK();
                }
            }

            @Override
            public String getDescription() {
                return Compat.CompatI18n.format("emojicord.gui.settings.waiting.desc.manual", new Object[0]).replace("\\n", "\n");
            }

            @Override
            public String getClosingDescription() {
                return Compat.CompatI18n.format("emojicord.gui.settings.aborting.desc.manual", new Object[0]).replace("\\n", "\n");
            }

            @Override
            public String getApplyPreferredDescription() {
                return Compat.CompatI18n.format("emojicord.gui.settings.completed.desc.manual", new Object[0]).replace("\\n", "\n");
            }

            @Override
            public void onOK() {
                this.closing = false;
                DiscordEmojiIdDictionary.instance.loadAll();
                EmojiSettings.this.addGui = null;
            }

            @Override
            public void onCancel() {
                this.closing = false;
            }
        }

        private class WebAdding
        implements EmojiAdding {
            private boolean closing;
            private boolean changed;

            public WebAdding() {
                EmojicordWeb.instance.open();
            }

            @Override
            public boolean isClosing() {
                return this.closing;
            }

            @Override
            public boolean isApplyPreferred() {
                if (!this.changed) {
                    this.changed = EmojicordWeb.instance.pollCallbacked();
                }
                return this.changed;
            }

            @Override
            public void onApplying() {
                this.closing = true;
                if (this.changed) {
                    this.onOK();
                }
            }

            @Override
            public String getDescription() {
                return Compat.CompatI18n.format("emojicord.gui.settings.waiting.desc.web", new Object[0]).replace("\\n", "\n");
            }

            @Override
            public String getClosingDescription() {
                return Compat.CompatI18n.format("emojicord.gui.settings.aborting.desc.web", new Object[0]).replace("\\n", "\n");
            }

            @Override
            public String getApplyPreferredDescription() {
                return Compat.CompatI18n.format("emojicord.gui.settings.completed.desc.web", new Object[0]).replace("\\n", "\n");
            }

            @Override
            public void onOK() {
                this.closing = false;
                DiscordEmojiIdDictionary.instance.loadAll();
                EmojiSettings.this.addGui = null;
            }

            @Override
            public void onCancel() {
                this.closing = false;
            }
        }
    }

    private static interface EmojiAdding {
        public boolean isClosing();

        default public boolean isApplyPreferred() {
            return false;
        }

        default public void onWindowFocus() {
        }

        public void onApplying();

        public String getDescription();

        public String getClosingDescription();

        public String getApplyPreferredDescription();

        default public void onOK() {
        }

        default public void onCancel() {
        }
    }
}

