/*
 * Decompiled with CFR 0.152.
 */
package net.teamfruit.emojicord.util;

import com.google.common.base.Charsets;
import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import javax.annotation.Nullable;
import net.teamfruit.emojicord.Log;
import net.teamfruit.emojicord.util.Downloader;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.StringBuilderWriter;
import org.apache.hc.client5.http.HttpResponseException;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;

public class DataUtils {
    public static final Gson gson = new Gson();

    private static void reportRead(Exception e, @Nullable String description) {
        if (description != null) {
            Log.log.warn("Failed to load " + description + ": ", (Throwable)e);
        }
    }

    private static void reportWrite(Exception e, @Nullable String description) {
        if (description != null) {
            Log.log.warn("Failed to save " + description + ": ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T readStream(InputStream stream, Class<T> clazz) throws Exception {
        Object object;
        JsonReader reader = null;
        try {
            reader = new JsonReader((Reader)new InputStreamReader(stream, Charsets.UTF_8));
            object = gson.fromJson(reader, clazz);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            IOUtils.closeQuietly((InputStream)stream);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)reader);
        IOUtils.closeQuietly((InputStream)stream);
        return (T)object;
    }

    @Nullable
    public static <T> T loadStream(InputStream stream, Class<T> clazz, @Nullable String description) {
        try {
            return DataUtils.readStream(stream, clazz);
        }
        catch (Exception e) {
            DataUtils.reportRead(e, description);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> boolean writeWriter(Writer stream, Class<T> clazz, T object) throws Exception {
        boolean bl;
        JsonWriter writer = null;
        try {
            writer = new JsonWriter(stream);
            writer.setIndent("  ");
            gson.toJson(object, clazz, writer);
            bl = true;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(writer);
            IOUtils.closeQuietly((Writer)stream);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)writer);
        IOUtils.closeQuietly((Writer)stream);
        return bl;
    }

    private static <T> boolean writeStream(OutputStream stream, Class<T> clazz, T object) throws Exception {
        return DataUtils.writeWriter(new OutputStreamWriter(stream, Charsets.UTF_8), clazz, object);
    }

    @Nullable
    private static <T> String writeString(Class<T> clazz, T object) throws Exception {
        StringBuilderWriter sbw = new StringBuilderWriter();
        if (DataUtils.writeWriter((Writer)sbw, clazz, object)) {
            return sbw.toString();
        }
        return null;
    }

    public static <T> boolean saveStream(OutputStream stream, Class<T> clazz, T object, @Nullable String description) {
        try {
            return DataUtils.writeStream(stream, clazz, object);
        }
        catch (Exception e) {
            DataUtils.reportWrite(e, description);
            return false;
        }
    }

    @Nullable
    public static <T> String saveString(Class<T> clazz, T object, @Nullable String description) {
        try {
            return DataUtils.writeString(clazz, object);
        }
        catch (Exception e) {
            DataUtils.reportWrite(e, description);
            return null;
        }
    }

    private static <T> T readFile(File file, Class<T> clazz) throws Exception {
        return DataUtils.readStream(FileUtils.openInputStream((File)file), clazz);
    }

    @Nullable
    public static <T> T loadFile(File file, Class<T> clazz, @Nullable String description) {
        try {
            return DataUtils.readFile(file, clazz);
        }
        catch (Exception e) {
            DataUtils.reportRead(e, description);
            return null;
        }
    }

    @Nullable
    public static <T> T loadFileIfExists(File file, Class<T> clazz, @Nullable String description) {
        if (file.exists()) {
            return DataUtils.loadFile(file, clazz, description);
        }
        return null;
    }

    private static <T> boolean writeFile(File file, Class<T> clazz, T object) throws Exception {
        return DataUtils.writeStream(FileUtils.openOutputStream((File)file), clazz, object);
    }

    public static <T> boolean saveFile(File file, Class<T> clazz, T object, @Nullable String description) {
        try {
            return DataUtils.writeFile(file, clazz, object);
        }
        catch (Exception e) {
            DataUtils.reportWrite(e, description);
            return false;
        }
    }

    private static InputStream getUrl(String url) throws Exception {
        HttpGet req = new HttpGet(url);
        HttpClientContext context = HttpClientContext.create();
        CloseableHttpResponse response = Downloader.downloader.client.execute((ClassicHttpRequest)req, context);
        HttpEntity entity = response.getEntity();
        int statusCode = response.getCode();
        if (statusCode != 200) {
            throw new HttpResponseException(statusCode, "Invalid status code: " + url);
        }
        return entity.getContent();
    }

    private static <T> T readUrl(String url, Class<T> clazz) throws Exception {
        return DataUtils.readStream(DataUtils.getUrl(url), clazz);
    }

    @Nullable
    public static <T> T loadUrl(String url, Class<T> clazz, @Nullable String description) {
        try {
            return DataUtils.readUrl(url, clazz);
        }
        catch (Exception e) {
            DataUtils.reportRead(e, description);
            return null;
        }
    }
}

