/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.core.util.vector;

import com.github.lunatrius.core.util.vector.Vector2f;
import com.github.lunatrius.core.util.vector.Vector2i;

public class Vector2d {
    public static final double DOUBLE_EPSILON = (double)1.0E-5f;
    public double x;
    public double y;

    public Vector2d() {
        this(0.0, 0.0);
    }

    public Vector2d(Vector2d vec) {
        this(vec.x, vec.y);
    }

    public Vector2d(double num) {
        this(num, num);
    }

    public Vector2d(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final void setX(double x) {
        this.x = x;
    }

    public final void setY(double y) {
        this.y = y;
    }

    public Vector2d set(Vector2d vec) {
        return this.set(vec.x, vec.y);
    }

    public Vector2d set(double x, double y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public final double length() {
        return Math.sqrt(this.lengthSquared());
    }

    public double lengthSquared() {
        return this.x * this.x + this.y * this.y;
    }

    public final double lengthTo(Vector2d vec) {
        return Math.sqrt(this.lengthSquaredTo(vec));
    }

    public double lengthSquaredTo(Vector2d vec) {
        return this.pow2(this.x - vec.x) + this.pow2(this.y - vec.y);
    }

    protected final double pow2(double num) {
        return num * num;
    }

    public final Vector2d normalize() {
        double len = this.length();
        if (len != 0.0) {
            return this.scale(1.0 / len);
        }
        return this;
    }

    public Vector2d negate() {
        this.x = -this.x;
        this.y = -this.y;
        return this;
    }

    public double dot(Vector2d vec) {
        return this.x * vec.x + this.y * vec.y;
    }

    public Vector2d scale(double scale) {
        this.x *= scale;
        this.y *= scale;
        return this;
    }

    public Vector2d add(Vector2d vec) {
        this.x += vec.x;
        this.y += vec.y;
        return this;
    }

    public Vector2d add(double x, double y) {
        this.x += x;
        this.y += y;
        return this;
    }

    public Vector2d sub(Vector2d vec) {
        this.x -= vec.x;
        this.y -= vec.y;
        return this;
    }

    public Vector2d sub(double x, double y) {
        this.x -= x;
        this.y -= y;
        return this;
    }

    public Vector2i toVector2i() {
        return new Vector2i((int)Math.floor(this.x), (int)Math.floor(this.y));
    }

    public Vector2i toVector2i(Vector2i vec) {
        return vec.set((int)Math.floor(this.x), (int)Math.floor(this.y));
    }

    public Vector2f toVector2f() {
        return new Vector2f((float)Math.floor(this.x), (float)Math.floor(this.y));
    }

    public Vector2f toVector2f(Vector2f vec) {
        return vec.set((float)Math.floor(this.x), (float)Math.floor(this.y));
    }

    public Vector2d clone() {
        return new Vector2d(this);
    }

    public boolean equals(Object obj) {
        return obj instanceof Vector2d && this.equals((Vector2d)obj);
    }

    public boolean equals(Vector2d vec) {
        return this.equals(vec, 1.0E-5f);
    }

    public boolean equals(Vector2d vec, double epsilon) {
        return Math.abs(this.x - vec.x) < epsilon && Math.abs(this.y - vec.y) < epsilon;
    }

    public String toString() {
        return String.format("[%s, %s]", this.x, this.y);
    }
}

