/*
 * Decompiled with CFR 0.152.
 */
package lain.mods.skins.init.forge;

import com.google.common.collect.ImmutableSet;
import com.mojang.authlib.GameProfile;
import java.nio.ByteBuffer;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import lain.mods.skins.api.SkinProviderAPI;
import lain.mods.skins.api.interfaces.ISkin;
import lain.mods.skins.impl.LegacyConversion;
import lain.mods.skins.impl.PlayerProfile;
import lain.mods.skins.impl.forge.CustomSkinTexture;
import lain.mods.skins.providers.CrafatarCapeProvider;
import lain.mods.skins.providers.CrafatarSkinProvider;
import lain.mods.skins.providers.CustomServerCapeProvider;
import lain.mods.skins.providers.CustomServerSkinProvider;
import lain.mods.skins.providers.MojangCapeProvider;
import lain.mods.skins.providers.MojangSkinProvider;
import lain.mods.skins.providers.UserManagedCapeProvider;
import lain.mods.skins.providers.UserManagedSkinProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod(modid="offlineskins", useMetadata=true, acceptedMinecraftVersions="[1.12, 1.13)", certificateFingerprint="aaaf83332a11df02406e9f266b1b65c1306f0f76")
public class ForgeOfflineSkins {
    @SideOnly(value=Side.CLIENT)
    private static boolean SkinPass;
    @SideOnly(value=Side.CLIENT)
    private static boolean CapePass;
    @SideOnly(value=Side.CLIENT)
    public static boolean OverrideVanilla;
    @SideOnly(value=Side.CLIENT)
    private static Set<String> DefaultSkins;
    @SideOnly(value=Side.CLIENT)
    private static Map<ByteBuffer, CustomSkinTexture> textures;

    @SideOnly(value=Side.CLIENT)
    public static ResourceLocation bindTexture(GameProfile profile, ResourceLocation result) {
        ISkin skin;
        if ((OverrideVanilla || ForgeOfflineSkins.isDefaultSkin(result)) && profile != null && (skin = SkinProviderAPI.SKIN.getSkin(PlayerProfile.wrapGameProfile(profile))) != null && skin.isDataReady()) {
            return ForgeOfflineSkins.getOrCreateTexture(skin.getData(), skin).getLocation();
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private static ResourceLocation generateRandomLocation() {
        return new ResourceLocation("offlineskins", String.format("textures/generated/%s", UUID.randomUUID().toString()));
    }

    @SideOnly(value=Side.CLIENT)
    public static ResourceLocation getLocationCape(AbstractClientPlayer player, ResourceLocation result) {
        ISkin skin;
        if (CapePass) {
            return null;
        }
        if ((OverrideVanilla || result == null) && (skin = SkinProviderAPI.CAPE.getSkin(PlayerProfile.wrapGameProfile(player.func_146103_bH()))) != null && skin.isDataReady()) {
            return ForgeOfflineSkins.getOrCreateTexture(skin.getData(), skin).getLocation();
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public static ResourceLocation getLocationSkin(AbstractClientPlayer player, ResourceLocation result) {
        ISkin skin;
        if (SkinPass) {
            return null;
        }
        if ((OverrideVanilla || ForgeOfflineSkins.isDefaultSkin(result)) && (skin = SkinProviderAPI.SKIN.getSkin(PlayerProfile.wrapGameProfile(player.func_146103_bH()))) != null && skin.isDataReady()) {
            return ForgeOfflineSkins.getOrCreateTexture(skin.getData(), skin).getLocation();
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private static CustomSkinTexture getOrCreateTexture(ByteBuffer data, ISkin skin) {
        if (!textures.containsKey(data)) {
            CustomSkinTexture texture = new CustomSkinTexture(ForgeOfflineSkins.generateRandomLocation(), data);
            FMLClientHandler.instance().getClient().func_110434_K().func_110579_a(texture.getLocation(), (ITextureObject)texture);
            textures.put(data, texture);
            if (skin != null) {
                skin.setRemovalListener(s -> {
                    if (data == s.getData()) {
                        FMLClientHandler.instance().getClient().func_152344_a(() -> {
                            FMLClientHandler.instance().getClient().func_110434_K().func_147645_c(texture.getLocation());
                            textures.remove(data);
                        });
                    }
                });
            }
        }
        return textures.get(data);
    }

    @SideOnly(value=Side.CLIENT)
    public static String getSkinType(AbstractClientPlayer player, String result) {
        ISkin skin;
        ResourceLocation location = ForgeOfflineSkins.getLocationSkin(player, null);
        if (location != null && (skin = SkinProviderAPI.SKIN.getSkin(PlayerProfile.wrapGameProfile(player.func_146103_bH()))) != null && skin.isDataReady()) {
            return skin.getSkinType();
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private static boolean isDefaultSkin(ResourceLocation location) {
        return "minecraft".equals(location.func_110624_b()) && DefaultSkins.contains(location.func_110623_a());
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void handleClientTicks(TickEvent.ClientTickEvent event) {
        WorldClient world;
        if (event.phase == TickEvent.Phase.START && (world = Minecraft.func_71410_x().field_71441_e) != null) {
            for (EntityPlayer player : world.field_73010_i) {
                SkinProviderAPI.SKIN.getSkin(PlayerProfile.wrapGameProfile(player.func_146103_bH()));
                SkinProviderAPI.CAPE.getSkin(PlayerProfile.wrapGameProfile(player.func_146103_bH()));
            }
        }
    }

    @Mod.EventHandler
    public void init(FMLPreInitializationEvent event) {
        if (event.getSide().isClient()) {
            DefaultSkins = ImmutableSet.of((Object)"textures/entity/steve.png", (Object)"textures/entity/alex.png");
            textures = new WeakHashMap<ByteBuffer, CustomSkinTexture>();
            Configuration config = new Configuration(event.getSuggestedConfigurationFile());
            boolean useMojang = config.getBoolean("useMojang", "client", true, "");
            boolean useCrafatar = config.getBoolean("useCrafatar", "client", true, "");
            boolean useCustomServer = config.getBoolean("useCustomServer", "client", false, "");
            String hostCustomServer = config.getString("hostCustomServer", "client", "http://example.com", "/skins/(uuid|username) and /capes/(uuid|username) will be queried for respective resources");
            if (config.hasChanged()) {
                config.save();
            }
            SkinProviderAPI.SKIN.clearProviders();
            SkinProviderAPI.SKIN.registerProvider(new UserManagedSkinProvider(Paths.get(".", "cachedImages")).withFilter(LegacyConversion.createFilter()));
            if (useCustomServer) {
                SkinProviderAPI.SKIN.registerProvider(new CustomServerSkinProvider().setHost(hostCustomServer).withFilter(LegacyConversion.createFilter()));
            }
            if (useMojang) {
                SkinProviderAPI.SKIN.registerProvider(new MojangSkinProvider().withFilter(LegacyConversion.createFilter()));
            }
            if (useCrafatar) {
                SkinProviderAPI.SKIN.registerProvider(new CrafatarSkinProvider().withFilter(LegacyConversion.createFilter()));
            }
            SkinProviderAPI.CAPE.clearProviders();
            SkinProviderAPI.CAPE.registerProvider(new UserManagedCapeProvider(Paths.get(".", "cachedImages")));
            if (useCustomServer) {
                SkinProviderAPI.CAPE.registerProvider(new CustomServerCapeProvider().setHost(hostCustomServer));
            }
            if (useMojang) {
                SkinProviderAPI.CAPE.registerProvider(new MojangCapeProvider());
            }
            if (useCrafatar) {
                SkinProviderAPI.CAPE.registerProvider(new CrafatarCapeProvider());
            }
            OverrideVanilla = true;
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
    }
}

