/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.util.HashMap;
import net.optifine.http.FileUploadThread;
import net.optifine.http.IFileUploadListener;
import net.optifine.shaders.Shaders;

public class CrashReporter {
    public static void onCrashReport(b crashReport, c category) {
        try {
            Throwable cause = crashReport.b();
            if (cause == null) {
                return;
            }
            if (cause.getClass().getName().contains(".fml.client.SplashProgress")) {
                return;
            }
            if (cause.getClass() == Throwable.class) {
                return;
            }
            CrashReporter.extendCrashReport(category);
            bid settings = Config.getGameSettings();
            if (settings == null) {
                return;
            }
            if (!settings.t) {
                return;
            }
            String url = "http://optifine.net/crashReport";
            String reportStr = CrashReporter.makeReport(crashReport);
            byte[] content = reportStr.getBytes("ASCII");
            IFileUploadListener listener = new IFileUploadListener(){

                @Override
                public void fileUploadFinished(String url, byte[] content, Throwable exception) {
                }
            };
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("OF-Version", Config.getVersion());
            headers.put("OF-Summary", CrashReporter.makeSummary(crashReport));
            FileUploadThread fut = new FileUploadThread(url, headers, content, listener);
            fut.setPriority(10);
            fut.start();
            Thread.sleep(1000L);
        }
        catch (Exception e2) {
            Config.dbg(e2.getClass().getName() + ": " + e2.getMessage());
        }
    }

    private static String makeReport(b crashReport) {
        StringBuffer sb = new StringBuffer();
        sb.append("OptiFineVersion: " + Config.getVersion() + "\n");
        sb.append("Summary: " + CrashReporter.makeSummary(crashReport) + "\n");
        sb.append("\n");
        sb.append(crashReport.e());
        sb.append("\n");
        return sb.toString();
    }

    private static String makeSummary(b crashReport) {
        Throwable t2 = crashReport.b();
        if (t2 == null) {
            return "Unknown";
        }
        StackTraceElement[] traces = t2.getStackTrace();
        String firstTrace = "unknown";
        if (traces.length > 0) {
            firstTrace = traces[0].toString().trim();
        }
        String sum = t2.getClass().getName() + ": " + t2.getMessage() + " (" + crashReport.a() + ") [" + firstTrace + "]";
        return sum;
    }

    public static void extendCrashReport(c cat2) {
        cat2.a("OptiFine Version", (Object)Config.getVersion());
        cat2.a("OptiFine Build", (Object)Config.getBuild());
        if (Config.getGameSettings() != null) {
            cat2.a("Render Distance Chunks", (Object)("" + Config.getChunkViewDistance()));
            cat2.a("Mipmaps", (Object)("" + Config.getMipmapLevels()));
            cat2.a("Anisotropic Filtering", (Object)("" + Config.getAnisotropicFilterLevel()));
            cat2.a("Antialiasing", (Object)("" + Config.getAntialiasingLevel()));
            cat2.a("Multitexture", (Object)("" + Config.isMultiTexture()));
        }
        cat2.a("Shaders", (Object)("" + Shaders.getShaderPackName()));
        cat2.a("OpenGlVersion", (Object)("" + Config.openGlVersion));
        cat2.a("OpenGlRenderer", (Object)("" + Config.openGlRenderer));
        cat2.a("OpenGlVendor", (Object)("" + Config.openGlVendor));
        cat2.a("CpuCount", (Object)("" + Config.getAvailableProcessors()));
    }
}

