/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.fluxloading.core.render;

import com.tttsaurus.fluxloading.core.render.GlResourceManager;
import com.tttsaurus.fluxloading.core.render.IGlDisposable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import net.minecraft.client.renderer.GlStateManager;
import org.lwjgl.opengl.GL11;

public final class Texture2D
implements IGlDisposable {
    private static final IntBuffer intBuffer = ByteBuffer.allocateDirect(64).order(ByteOrder.nativeOrder()).asIntBuffer();
    private int glTextureID = 0;
    private final int width;
    private final int height;
    private boolean isGlBounded;

    public int getGlTextureID() {
        return this.glTextureID;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean getIsGlBounded() {
        return this.isGlBounded;
    }

    public Texture2D(int width, int height, ByteBuffer byteBuffer) {
        GL11.glGetInteger((int)32873, (IntBuffer)intBuffer);
        int textureID = intBuffer.get(0);
        this.glTextureID = GL11.glGenTextures();
        this.width = width;
        this.height = height;
        GL11.glBindTexture((int)3553, (int)this.glTextureID);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        GL11.glTexImage2D((int)3553, (int)0, (int)32856, (int)width, (int)height, (int)0, (int)6408, (int)5121, (ByteBuffer)byteBuffer);
        this.isGlBounded = true;
        GlStateManager.func_179144_i((int)textureID);
        GlResourceManager.addDisposable(this);
    }

    @Override
    public void dispose() {
        if (this.glTextureID != 0) {
            GL11.glDeleteTextures((int)this.glTextureID);
        }
        this.glTextureID = 0;
        this.isGlBounded = false;
        GlResourceManager.removeDisposable(this);
    }
}

