/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.fluxloading.core.util;

import javax.annotation.Nullable;

public final class TypeUtils {
    public static boolean looseTypeCheck(Class<?> clazz1, Class<?> clazz2) {
        if (clazz1.getName().equals(clazz2.getName())) {
            return true;
        }
        if (TypeUtils.isIntOrWrappedInt(clazz1) && TypeUtils.isIntOrWrappedInt(clazz2)) {
            return true;
        }
        if (TypeUtils.isLongOrWrappedLong(clazz1) && TypeUtils.isLongOrWrappedLong(clazz2)) {
            return true;
        }
        if (TypeUtils.isShortOrWrappedShort(clazz1) && TypeUtils.isShortOrWrappedShort(clazz2)) {
            return true;
        }
        if (TypeUtils.isByteOrWrappedByte(clazz1) && TypeUtils.isByteOrWrappedByte(clazz2)) {
            return true;
        }
        if (TypeUtils.isDoubleOrWrappedDouble(clazz1) && TypeUtils.isDoubleOrWrappedDouble(clazz2)) {
            return true;
        }
        if (TypeUtils.isFloatOrWrappedFloat(clazz1) && TypeUtils.isFloatOrWrappedFloat(clazz2)) {
            return true;
        }
        if (TypeUtils.isCharacterOrWrappedCharacter(clazz1) && TypeUtils.isCharacterOrWrappedCharacter(clazz2)) {
            return true;
        }
        return TypeUtils.isBooleanOrWrappedBoolean(clazz1) && TypeUtils.isBooleanOrWrappedBoolean(clazz2);
    }

    public static boolean isFromParentPackage(Class<?> clazz, String packageName) {
        return clazz.getName().startsWith(packageName);
    }

    @Nullable
    public static Class<?> toWrappedPrimitive(Class<?> primitiveClass) {
        Class clazz;
        switch (primitiveClass.getName()) {
            case "int": {
                clazz = Integer.class;
                break;
            }
            case "long": {
                clazz = Long.class;
                break;
            }
            case "short": {
                clazz = Short.class;
                break;
            }
            case "byte": {
                clazz = Byte.class;
                break;
            }
            case "double": {
                clazz = Double.class;
                break;
            }
            case "float": {
                clazz = Float.class;
                break;
            }
            case "char": {
                clazz = Character.class;
                break;
            }
            case "boolean": {
                clazz = Boolean.class;
                break;
            }
            default: {
                clazz = null;
            }
        }
        return clazz;
    }

    public static boolean isPrimitiveOrWrappedPrimitive(Class<?> clazz) {
        return clazz.isPrimitive() || clazz == Integer.class || clazz == Long.class || clazz == Short.class || clazz == Byte.class || clazz == Double.class || clazz == Float.class || clazz == Character.class || clazz == Boolean.class;
    }

    public static boolean isIntOrWrappedInt(Class<?> clazz) {
        return clazz.getName().equals("int") || clazz.equals(Integer.class);
    }

    public static boolean isLongOrWrappedLong(Class<?> clazz) {
        return clazz.getName().equals("long") || clazz.equals(Long.class);
    }

    public static boolean isShortOrWrappedShort(Class<?> clazz) {
        return clazz.getName().equals("short") || clazz.equals(Short.class);
    }

    public static boolean isByteOrWrappedByte(Class<?> clazz) {
        return clazz.getName().equals("byte") || clazz.equals(Byte.class);
    }

    public static boolean isDoubleOrWrappedDouble(Class<?> clazz) {
        return clazz.getName().equals("double") || clazz.equals(Double.class);
    }

    public static boolean isFloatOrWrappedFloat(Class<?> clazz) {
        return clazz.getName().equals("float") || clazz.equals(Float.class);
    }

    public static boolean isCharacterOrWrappedCharacter(Class<?> clazz) {
        return clazz.getName().equals("char") || clazz.equals(Character.class);
    }

    public static boolean isBooleanOrWrappedBoolean(Class<?> clazz) {
        return clazz.getName().equals("boolean") || clazz.equals(Boolean.class);
    }
}

