/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.fluxloading.mixin.early;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.tttsaurus.fluxloading.core.FluxLoadingAPI;
import com.tttsaurus.fluxloading.core.FluxLoadingManager;
import com.tttsaurus.fluxloading.core.accessor.TessellatorAccessor;
import com.tttsaurus.fluxloading.core.render.RenderUtils;
import net.minecraft.client.LoadingScreenRenderer;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.resources.I18n;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={LoadingScreenRenderer.class})
public class LoadingScreenRendererMixin {
    @Unique
    private static BufferBuilder fluxloading$proxyBufferBuilder;

    @WrapOperation(method={"setLoadingProgress"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/Tessellator;getBuffer()Lnet/minecraft/client/renderer/BufferBuilder;")})
    public BufferBuilder getBuffer(Tessellator instance, Operation<BufferBuilder> original) {
        if (FluxLoadingAPI.isActive()) {
            if (fluxloading$proxyBufferBuilder == null) {
                fluxloading$proxyBufferBuilder = new BufferBuilder(64);
            }
            return fluxloading$proxyBufferBuilder;
        }
        return (BufferBuilder)original.call(new Object[]{instance});
    }

    @WrapOperation(method={"setLoadingProgress"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/Tessellator;draw()V", ordinal=0)})
    public void draw0(Tessellator instance, Operation<Void> original) {
        if (FluxLoadingAPI.isActive()) {
            FluxLoadingManager.drawOverlayDefaultWorldLoadingAndFadingInPhase();
            FluxLoadingManager.tick();
            fluxloading$proxyBufferBuilder.func_178977_d();
            fluxloading$proxyBufferBuilder.func_178965_a();
        } else {
            original.call(new Object[]{instance});
        }
    }

    @WrapOperation(method={"setLoadingProgress"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/Tessellator;draw()V", ordinal=1)})
    public void draw1(Tessellator instance, Operation<Void> original) {
        if (FluxLoadingAPI.isActive()) {
            Tessellator tessellator = Tessellator.func_178181_a();
            WorldVertexBufferUploader vboUploader = TessellatorAccessor.getVboUploader(tessellator);
            fluxloading$proxyBufferBuilder.func_178977_d();
            vboUploader.func_181679_a(fluxloading$proxyBufferBuilder);
            fluxloading$proxyBufferBuilder.func_178965_a();
        } else {
            original.call(new Object[]{instance});
        }
    }

    @WrapOperation(method={"setLoadingProgress"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/FontRenderer;drawStringWithShadow(Ljava/lang/String;FFI)I", ordinal=0)})
    public int drawStringWithShadow0(FontRenderer instance, String text, float x, float y, int color, Operation<Integer> original) {
        if (FluxLoadingAPI.isActive() && FluxLoadingManager.isDisableVanillaTexts()) {
            return 0;
        }
        int res = (Integer)original.call(new Object[]{instance, text, Float.valueOf(x), Float.valueOf(y), color});
        if (FluxLoadingAPI.isActive()) {
            if (FluxLoadingManager.isForceLoadingTitle() && text != null && !text.isEmpty()) {
                FluxLoadingManager.setForceLoadingTitle(false);
            }
            if (FluxLoadingManager.isForceLoadingTitle()) {
                String i18nText = I18n.func_135052_a((String)"menu.loadingLevel", (Object[])new Object[0]);
                int width = RenderUtils.fontRenderer.func_78256_a(i18nText);
                RenderUtils.renderText(i18nText, x - (float)((int)((float)width / 2.0f)), y, 1.0f, color, true);
            }
        }
        return res;
    }

    @WrapOperation(method={"setLoadingProgress"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/FontRenderer;drawStringWithShadow(Ljava/lang/String;FFI)I", ordinal=1)})
    public int drawStringWithShadow1(FontRenderer instance, String text, float x, float y, int color, Operation<Integer> original) {
        if (FluxLoadingAPI.isActive() && FluxLoadingManager.isDisableVanillaTexts()) {
            return 0;
        }
        return (Integer)original.call(new Object[]{instance, text, Float.valueOf(x), Float.valueOf(y), color});
    }
}

